% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RCdat}
\alias{RCdat}
\title{Sample participant data from a binary risky choice task (aka risk aversion task)}
\format{
A data frame with 120 rows and 3 variables:
\describe{
  \item{Amt1}{Probabilistic reward amount, in dollars}
  \item{Prob1}{Probability of winning \code{Amt1}, if it were to be chosen}
  \item{Choice}{Choice between binary options. \code{Choice==1} means participnat chose the probabilistic option (i.e., \code{Amt1} with \code{Delay1} chance of winning). \code{Choice==0} means participnat chose the certain option (i.e., $20 for sure)}
}
}
\source{
Kable, J. W., Caulfield, M. K., Falcone, M., McConnell, M., Bernardo, L., Parthasarathi, T., ... & Diefenbach, P. (2017). No effect of commercial cognitive training on brain activity, choice behavior, or cognitive performance. Journal of Neuroscience, 37(31), 7390-7402.
}
\usage{
RCdat
}
\description{
A dataset containing one sample participant's 120 binary choices between a probabilistic monetary option (\code{Amt1} with \code{Prob1} chance of winning) and a certain monetary option ($20 for sure).
The certain monetary option was always '$20 for sure' across all trials
}
\keyword{datasets}
