% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplotcorr}
\alias{CGGPplotcorr}
\title{Plot correlation samples}
\usage{
CGGPplotcorr(
  Corr = CGGP_internal_CorrMatGaussian,
  theta = NULL,
  numlines = 20,
  outdims = NULL,
  zero = TRUE
)
}
\arguments{
\item{Corr}{Correlation function or CGGP object.
If CGGP object, it will make plots for thetaMAP,
the max a posteriori theta.}

\item{theta}{Parameters for Corr}

\item{numlines}{Number of sample paths to draw}

\item{outdims}{Which output dimensions should be used?}

\item{zero}{Should the sample paths start at y=0?}
}
\value{
Plot
}
\description{
Plot samples for a given correlation function and parameters.
Useful for getting an idea of what the correlation parameters mean
in terms of smoothness.
}
\examples{
\donttest{
CGGPplotcorr()
CGGPplotcorr(theta=c(-2,-1,0,1))

SG <- CGGPcreate(d=3, batchsize=100)
f <- function(x){x[1]^1.2+sin(2*pi*x[2]*3)}
y <- apply(SG$design, 1, f)
SG <- CGGPfit(SG, Y=y)
CGGPplotcorr(SG)
}
}
\seealso{
Other CGGP plot functions: 
\code{\link{CGGPplotblocks}()},
\code{\link{CGGPplotheat}()},
\code{\link{CGGPplothist}()},
\code{\link{CGGPplotsamplesneglogpost}()},
\code{\link{CGGPplotslice}()},
\code{\link{CGGPplottheta}()},
\code{\link{CGGPplotvariogram}()},
\code{\link{CGGPvalplot}()}
}
\concept{CGGP plot functions}
