% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{summary_calculate_centralities}
\alias{summary_calculate_centralities}
\title{Summarize centrality measure calculation results}
\usage{
summary_calculate_centralities(x)
}
\arguments{
\item{x}{Centrality measure calculation results, typically a numeric vector.}
}
\value{
A list summarizing the computed centrality measures. The list includes the following elements:
- "minimum": The minimum value of the centrality measures.
- "first_quartile": The first quartile (25th percentile) value of the centrality measures.
- "median": The median (50th percentile) value of the centrality measures.
- "mean": The mean value of the centrality measures.
- "third_quartile": The third quartile (75th percentile) value of the centrality measures.
- "maximum": The maximum value of the centrality measures.
}
\description{
This function computes the minimum, first quartile, median,
mean, third quartile, and maximum values of the computed centrality measures.
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
