% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulationStudyFunctions.R
\name{GenerateToyData}
\alias{GenerateToyData}
\title{Generate 'Toy' Data}
\usage{
GenerateToyData(
  n,
  p1,
  p2,
  JntVarEx1,
  JntVarEx2,
  IndVarEx1,
  IndVarEx2,
  jnt_rank = 1,
  equal.eig = FALSE,
  ind_rank1 = 2,
  ind_rank2 = 2,
  SVD.plots = TRUE,
  Error = TRUE,
  print.cor = TRUE
)
}
\arguments{
\item{n}{integer for sample size, i.e. number of subjects}

\item{p1}{integer for number of features/variables in first data set}

\item{p2}{integer for number of features/variables in second data set}

\item{JntVarEx1}{numeric between (0,1) which describes proportion of variance in the first data set which is attributable to the joint signal}

\item{JntVarEx2}{numeric between (0,1) which describes proportion of variance in the second data set which is attributable to the joint signal}

\item{IndVarEx1}{numeric between (0,1) which describes proportion of variance in the first data set which is attributable to the individual signal}

\item{IndVarEx2}{numeric between (0,1) which describes proportion of variance in the second data set which is attributable to the individual signal}

\item{jnt_rank}{integer for rank of the joint signal, i.e., number of joint components}

\item{equal.eig}{logical (TRUE/FALSE) for whether components should contribute equal variance to signal matrices - default is FALSE}

\item{ind_rank1}{integer for rank of the individual signal in first data set, i.e., number of joint components}

\item{ind_rank2}{integer for rank of the individual signal in second data set, i.e., number of joint components}

\item{SVD.plots}{logical (TRUE/FALSE)  for whether plots of singular values from signal should be produced - used to confirm number of components}

\item{Error}{logical (TRUE/FALSE)  final data sets should be noise contaminated - default is FALSE; use TRUE to obtain pure signal datasets}

\item{print.cor}{logical (TRUE/FALSE)  for whether to print matrix of correlations between subject scores)}
}
\value{
A 'list' object which contains 1) list of signal matrices which additively comprise the simulated data sets, i.e. joint, individual,
        and error matrices for each data set; 2) list of simulated data sets (each equal to the sum of the matrices in part 1);
        3) list of joint subject scores and individual subject scores for each data set, and 4) lsit of joint and individual loadings for each data set
}
\description{
Generates two Simulated Datasets that follow JIVE Model using binary subject scores
}
\examples{
ToyDat = GenerateToyData(n = 200, p1 = 2000, p2 = 1000, JntVarEx1 = 0.05, JntVarEx2 = 0.05,
                           IndVarEx1 = 0.25, IndVarEx2 = 0.25, jnt_rank = 1, equal.eig = FALSE,
                           ind_rank1 = 2, ind_rank2 = 3, SVD.plots = TRUE, Error = TRUE,
                           print.cor = TRUE)
}
