% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulationStudyFunctions.R
\name{Melt.Sim.Cors}
\alias{Melt.Sim.Cors}
\title{Converts correlations of predicted to true joint subject scores to a format conducive to ggplot2}
\usage{
Melt.Sim.Cors(sim.dat, r.J, p1, p2)
}
\arguments{
\item{sim.dat}{matrix with each row representing results from a replicate in the simulation study described in CJIVE manuscript}

\item{r.J}{(Numeric/integer) the joint rank, i.e. number of components in the joint subspace}

\item{p1}{number of variables/features in data set X1}

\item{p2}{number of variables/features in data set X2}
}
\value{
data frame with seven columns: one each for the joint variance explained in each data set,
        one column containing the method by which predictions were obtained,
        one column containing the component number (1,...,r.J),
}
\description{
Converts correlations of predicted to true joint subject scores into a format conducive to ggplot2
}
