% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{chord.norm.diff}
\alias{chord.norm.diff}
\title{Chordal norm between column-subspaces of two matrices}
\usage{
chord.norm.diff(X, Y, tol = 1e-08)
}
\arguments{
\item{X}{a matrix with the same number of rows as Y and any number of columns}

\item{Y}{a matrix with the same number of rows as X and any number of columns}

\item{tol}{threshold under which singular values of inner product are zeroed out}
}
\value{
(Numeric) Chordal norm between column-subspaces of X and Y, scaled to the interval [0,1]
}
\description{
Calculates the chordal norm between the column subspaces of two matrices. Matrices must have the same number of rows. Let U_x and U_y represent the singular
             vectors of matrices X and Y, respectively. The chordal norm can be calculated as the square root of the sum of the singular values of t(U_x)%*%U_y
}
