% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_poles.R
\name{safety_cof_poles}
\alias{safety_cof_poles}
\title{Safety cost of Failure for Pole}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
safety_cof_poles(pole_asset_category, location_risk, type_risk)
}
\arguments{
\item{pole_asset_category}{String The type of pole asset category
Options: \code{pole_asset_category = c("LV Poles", "6.6/11kV Poles",
"20kV Poles", "33kV Pole", "66kV Pole")}.}

\item{location_risk}{String Type Financial factor criteria for Pole
(cf. section D1.2.1, page 178, CNAIM, 2021).
Options: \code{location_risk = c("Low", "Medium", "High")}.
The default setting is
\code{location_risk = "Medium"}.}

\item{type_risk}{String. Asses Financial factor criteria for pole
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{type_risk = c("Low", "Medium", "High")}.
The default setting is
\code{type_risk = "Medium"}.}
}
\value{
Numeric. Safety consequences of failure for poles
}
\description{
This function calculates safety consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Safety consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
safety_cof_poles(pole_asset_category = "33kV Pole",
location_risk = "Default",
type_risk = "Default")
}
