% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{i_median_grp}
\alias{i_median_grp}
\title{Impute by group median}
\usage{
i_median_grp(x, f, skip_f_na = TRUE)
}
\arguments{
\item{x}{A numeric vector}

\item{f}{A grouping variable, of the same length of \code{x}, that specifies the group that each value
of \code{x} belongs to. This will be coerced to a factor.}

\item{skip_f_na}{If \code{TRUE}, will work around any \code{NA}s in \code{f} (the corresponding values of \code{x} will be excluded from the imputation
and returned unaltered). Else if \code{FALSE}, will cause an error.}
}
\value{
A numeric vector
}
\description{
Replaces \code{NA}s in a numeric vector with the grouped medians of the non-\code{NA} values.
Groups are defined by the \code{f} argument.
}
\examples{
x <- c(NA, runif(10), NA)
f <- c(rep("a", 6), rep("b", 6))
i_median_grp(x, f)

}
