% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_saw.R
\name{CPP.SAW}
\alias{CPP.SAW}
\title{CPP by weighted sum, with weights informed by the user}
\usage{
CPP.SAW(x, w)
}
\arguments{
\item{x}{Decision matrix of Alternatives (rows) and Criteria (columns). Benefit criteria must be positive and cost criteria must be negative.}

\item{w}{Vector of weights assigned by the decision maker. Weights are normalized, just in case their sum differs from the unity.}
}
\value{
Weights repeat the parameter 'w' if sum the unity, otherwise are normalized. PMax indicates the joint probabilities of each alternative being higher than the others, per criterion. CPP returns the alternatives' scores by weighted sum, indicating the preference ranks for decisionmaking.
}
\description{
This function computes the CPP-SAW, using Normal distributions and weights defined by the decision maker. The CPP-SAW is used to evaluate alternatives by weighted sum.
}
\examples{
# Decision matrix
Alt.1 = c(2,30,86,-5)
Alt.2 = c(4,26,77,-12)
Alt.3 = c(3,22,93,-4)
Alt.4 = c(6,34,65,-10)
Alt.5 = c(5,31,80,-8)
Alt.6 = c(6,29,79,-9)
Alt.7 = c(8,37,55,-15)
Alt.8 = c(10,21,69,-11)
x = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5,Alt.6,Alt.7,Alt.8)
w = c(0.2,0.3,0.4,0.1)
CPP.SAW(x,w)
}
\references{
Sant'Anna, Annibal P. (2015). Probabilistic Composition of Preferences: Theory and Applications, Springer.
}
