% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.survdata.R
\name{sim.survdata}
\alias{sim.survdata}
\title{Simulate Survival Data with Change Point}
\usage{
sim.survdata(time, event, changeP, shape, scale, censoring, censpoint,
  times.int, parametric)
}
\arguments{
\item{time}{Numeric vector with survival times.}

\item{event}{Numeric vector indicating censoring status; 0 = alive (censored), 1 =
dead (uncensored). If missing, all observations are assumed to be
uncensored.}

\item{changeP}{Change point.}

\item{shape}{Shape parameter of Weibull distribution.}

\item{scale}{Scale parameter of Weibull distribution.}

\item{censoring}{Logical; if \code{TRUE}, censored data are generated.}

\item{censpoint}{Censoring point for Type I censoring.}

\item{times.int}{Logical; if \code{TRUE}, returned survival times are
integers.}

\item{parametric}{Logical; if \code{TRUE}, survival times are generated
parametrically by inverse transform sampling; otherwise Kaplan-Meier is
used for simulation.}
}
\value{
A dataset with survival times and corresponding censoring status
  ('event').
}
\description{
Simulates Weibull distributed survival data from a given data set with
change point above which hazard rate is constant.
}
