% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSeQTL.R
\name{CSeQTL_GS}
\alias{CSeQTL_GS}
\title{CSeQTL_GS}
\usage{
CSeQTL_GS(
  XX,
  TREC,
  SNP,
  hap2,
  ASREC,
  PHASE,
  RHO,
  trim = TRUE,
  thres_TRIM = 20,
  numAS = 5,
  numASn = 5,
  numAS_het = 5,
  cistrans = 0.01,
  ncores = 1,
  show = TRUE
)
}
\arguments{
\item{XX}{A numeric design matrix of baseline covariates 
including the intercept in the first column and centered 
continuous covariates. One of the non-intercept columns
should correspond to centered log-transformed library size.
The \code{rownames(XX)} needs to be specified.}

\item{TREC}{An integer vector containing one gene's 
total read counts.
The \code{names(TREC)} needs to be specified.}

\item{SNP}{A nonnegative integer matrix with genotypes. Values
should be coded 0, 1, 2, 3, 5 for genotypes AA, AB, BA, BB, NA, respectively.
Rows correspond to SNPs and columns correspond to subjects.
 The \code{rownames(SNP)} needs to be specified.}

\item{hap2}{An integer vector of the second haplotype's
counts for the gene. The \code{names(hap2)} needs to be specified
and match \code{names(TREC)}.}

\item{ASREC}{An integer vector of the total haplotype
counts (ASReC) for the gene. The \code{names(ASREC)} needs to be specified
and match \code{names(TREC)}.}

\item{PHASE}{A binary 0/1 vector indicating if haplotype counts
for the gene will be used. The \code{names(PHASE)} needs to be specified
and match \code{names(TREC)}.}

\item{RHO}{A numeric matrix of cell type proportions. Rows 
correspond to subjects and columns correspond to cell types. 
The \code{rownames(RHO)} needs to be specified
and match \code{names(TREC)}. The \code{colnames(RHO)} 
also needs to be specified.}

\item{trim}{Boolean value set to \code{FALSE} by default to prevent
outcome trimming. If \code{TRUE}, the CSeQTL model will be fitted
without SNP genotype to calculate each subject's Cooks' distance
for the gene.}

\item{thres_TRIM}{A positive numeric value to perform subject outcome trimming.
Subjects with standardized Cooks' Distances greater than the threshold are trimmed.}

\item{numAS}{A positive integer to determine if a subject has
enough total haplotype counts.}

\item{numASn}{A positive integer to determine how many subjects
have at least \code{numAS} to use the haplotype counts.}

\item{numAS_het}{A positive integer to determine how many subjects
with at least \code{numAS} are heterozygous (AB or BA). If
\code{sum(PHASE == 1 & ASREC >= numAS & (SNP == 1 | SNP == 2)) >= numAS_het},
those subjects haplotype counts will be used for TReCASE and cis/trans 
testing and estimation.}

\item{cistrans}{A numeric value specifying the cis/trans test p-value cutoff
to determine if the eQTLs from TReC-only or TReCASE model is reported.}

\item{ncores}{A positive integer specifying the number of threads available
to decrease computational runtime when performing trimming and looping through SNPs.}

\item{show}{A boolean value to display verbose output.}
}
\value{
A R list of statistics and metrics after optimizing the model across multiple SNPs.
The list contains parameter MLEs, gene expression estimates, fold change estimates, 
convergence indicators, likelihood ratio test statistics, and associated p-values.
}
\description{
Main function that performs eQTL mapping on one 
gene with its associated SNPs.
}
