% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteRingFromImage.R
\name{deleteRingFromImage}
\alias{deleteRingFromImage}
\title{Add ring to pith to bark profile from CT scan image}
\usage{
deleteRingFromImage(n = 1, densProfile, im)
}
\arguments{
\item{n}{Number of rings to remove}

\item{densProfile}{Density profile}

\item{im}{Density matrix}
}
\value{
Corrected density profile with ring(s) removed and red bar in plot of deleted ring
}
\description{
Add ring to pith to bark profile from CT scan image
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

endPath <- c(472, 284) # manual

densPath <- extractProfile(im_dens,
                           image_info,
                           pith_coord,
                           endPath,
                           k = 2, r = 5,
                           threshold = 0.002)

newPath2 <- addRingFromImage(n = 1, densPath, im_dens)
oldPath2 <- deleteRingFromImage(n = 1, densPath, im_dens)
}
