% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varcovgecub.R
\name{varcovgecub}
\alias{varcovgecub}
\title{Variance-covariance matrix of a CUB model without covariates}
\usage{
varcovgecub(ordinal,Y,W,X,bet,gama,omega,shelter)
}
\arguments{
\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of selected covariates to explain the uncertainty component (default: no covariate is included
in the model)}

\item{W}{Y Matrix of selected covariates to explain the feeling component (default: no covariate is included
in the model)}

\item{X}{Matrix of selected covariates to explain the shelter component (default: no covariate is included
in the model)}

\item{bet}{Parameter vector for the Uncertainty component}

\item{gama}{Parameter vector for the Feeling component}

\item{omega}{Parameter vector for the shelter component}

\item{shelter}{Cateogry corresponding to the shelter effect}
}
\description{
Compute the variance-covariance matrix of parameter estimates of a CUB model without covariates.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not,
it returns a warning message and produces a matrix with NA entries.
}
\seealso{
\code{\link{probgecub}}
}
\keyword{internal}
