% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inverse_Weibull_Formula.R
\name{Inverse_Weibull_Formula}
\alias{Inverse_Weibull_Formula}
\title{Inverse Weibull Formula}
\usage{
Inverse_Weibull_Formula(concentration, shape_location, scale)
}
\arguments{
\item{concentration}{The vector of concentration values for a selected pesticide,
that has a Inverse Weibull shaped species sensitivity distribution,
to run the equation on.}

\item{shape_location}{The Inverse Weibull shape/alpha value for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}

\item{scale}{The Inverse Weibull scale/beta value for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}
}
\value{
a numeric vector
}
\description{
Inverse Weibull Formula
}
\examples{
Hexazinone <- c(0.000000001, 0.5, 2.7, 11)
#Hexazinone is used as its species sensitivity distribution plots fits Inverse Weibull
Inverse_Weibull_Formula(concentration = Hexazinone,
shape_location = pesticide_info$shape_location[pesticide_info$pesticide == "Hexazinone"],
scale = pesticide_info$scale[pesticide_info$pesticide == "Hexazinone"])
}
