% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_your_own_pesticide.R
\name{add_your_own_pesticide}
\alias{add_your_own_pesticide}
\title{Add new pesticides to the pesticide_info table}
\usage{
add_your_own_pesticide(
  pesticides,
  relative_LORs,
  pesticide_types,
  distribution_types,
  shape_locations = NA,
  shape_location_2s = NA,
  scales = NA,
  scale_2s = NA,
  weights = NA,
  pesticide_info = CalcThemAll.PRM::pesticide_info
)
}
\arguments{
\item{pesticides}{A vector of pesticide names}

\item{relative_LORs}{A vector of relative limit of reporting
replacement values}

\item{pesticide_types}{A vector of the new pesticide's types}

\item{distribution_types}{A vector of the new pesticide's species
sensitivity distribution types}

\item{shape_locations}{A vector of shape/location values (if applicable, else put NA)}

\item{shape_location_2s}{A vector of secondary shape/location values (if applicable, else put NA)}

\item{scales}{A vector of scale values (if applicable, else put NA)}

\item{scale_2s}{A vector of secondary scale values (if applicable, else put NA)}

\item{weights}{A vector of weight values (if applicable, else put NA)}

\item{pesticide_info}{A data set to add pesticides too}
}
\value{
A data frame
}
\description{
Add new pesticides to the pesticide_info table
}
\examples{
new <- add_your_own_pesticide(pesticides = "Poison", relative_LORs = 0.023,
pesticide_types = "Poison", distribution_types = "Log-Normal", scales = 0.09,
shape_locations = 0.014)
multiple_new <- add_your_own_pesticide(pesticides = c("Poison", "Acid", "Sludge"),
relative_LORs = c(0.03, 0.01, 0.5), pesticide_types = c("Poison", "Acid", "Sludge"),
distribution_types = c("Log-Normal", "Log-Logistic Log-Logistic", "Burr Type III"),
scales = c(0.3, 0.002, 2),
scale_2s = c(NA, 0.04, NA),  shape_locations = c(1, 0.07, 3),
shape_location_2s = c(NA, 0.14, 2.3), weights = c(NA, 0.08, NA))
}
