% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calSSB.R
\name{CalSSBobjReGenesees}
\alias{CalSSBobjReGenesees}
\title{Create a CalSSB object from a ReGenesees/cal.analytic object}
\usage{
CalSSBobjReGenesees(
  x,
  y,
  samplingWeights = NULL,
  extra = NULL,
  id = NULL,
  wave = NULL
)
}
\arguments{
\item{x}{Output from ReGenesees::e.calibrate() (object of class cal.analytic)}

\item{y}{formula or variable names}

\item{samplingWeights}{NULL, TRUE (capture from x), formula, variable name or vector of data}

\item{extra}{NULL, formula, variable names or matrix of data}

\item{id}{NULL, TRUE (ids from x), formula, variable name or vector of data}

\item{wave}{NULL,  formula, variable name or vector of data}
}
\value{
A CalSSB object. That is, an object of the type retuned by \code{\link{CalibrateSSB}}.
}
\description{
Create a CalSSB object from a ReGenesees/cal.analytic object
}
\examples{
\dontrun{
# Generates data - two years
z <- AkuData(3000)  # 3000 in each quarter
zPop <- AkuData(10000)[, 1:7]
z$samplingWeights <- 1
z$ids <- 1:NROW(z)

# Create a ReGenesees/cal.analytic object
library("ReGenesees")
desReGenesees <- e.svydesign(z[z$R == 1, ], ids = ~ids, weights = ~samplingWeights)
popTemplate <- pop.template(data = desReGenesees, calmodel = ~sex * age, partition = ~year + q)
popTotals <- fill.template(universe = zPop, template = popTemplate)
calReGenesees <- e.calibrate(design = desReGenesees, df.population = popTotals)

# Create CalSSB objects from a ReGenesees/cal.analytic object
CalSSBobjReGenesees(calReGenesees, y = ~unemployed + workforce, id = TRUE, 
                    samplingWeights = TRUE, extra = ~famid)
a <- CalSSBobjReGenesees(calReGenesees, y = c("unemployed", "workforce"), 
                         id = "id", extra = "famid", wave = c("year", "q"))

# Use the CalSSB object as input ...
PanelEstimation(WideFromCalibrate(a), "unemployed", linComb = PeriodDiff(8, 4))

}
}
\seealso{
\code{\link{CalibrateSSB}}, \code{\link{CalSSBobj}}, \code{\link{WideFromCalibrate}},  \code{\link{PanelEstimation}}.
}
