% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyResults.R
\name{resultsUI}
\alias{resultsUI}
\title{Generate and Report Model Diagnostics from NLME or NONMEM runs}
\usage{
resultsUI(model, xpdb = NULL, tagged = NULL, settings = NULL, ...)
}
\arguments{
\item{model}{A single object, vector, or list of objects of class \code{NlmePmlModel}.}

\item{xpdb}{A single object or list of objects of class \code{xpose_data}.}

\item{tagged}{List of tagged objects returned from previous \code{tagged <- resultsUI()} session.}

\item{settings}{List of settings (e.g., settings.Rds) returned from previous Shiny session.}

\item{...}{Additional arguments for Pirana integration.}
}
\value{
If \code{interactive()}, returns a list of tagged diagnostics from the Shiny application, otherwise returns \code{TRUE}.
}
\description{
Shiny application to generate, customize, and report diagnostic plots and tables from NLME or
NONMEM output files. Create an Rmarkdown file of tagged model diagnostics and render into
submission ready report.
}
\examples{
if (interactive()) {


# RsNLME
library(Certara.RsNLME)
library(Certara.ModelResults)

model1 <- pkmodel(numCompartments = 1,
                 data = pkData,
                 ID = "Subject",
                 Time = "Act_Time",
                 A1 = "Amount",
                 CObs = "Conc",
                 modelName = "OneCpt_IVBolus_FOCE-ELS")

baseFitJob1 <- fitmodel(model1)


model2 <- pkmodel(numCompartments = 2,
                 data = pkData,
                 ID = "Subject",
                 Time = "Act_Time",
                 A1 = "Amount",
                 CObs = "Conc",
                 modelName = "TwCpt_IVBolus_FOCE-ELS")

baseFitJob2 <- fitmodel(model2)

# Run Model Results
resultsUI(model = c(model1, model2))


# NONMEM via xpose

library(Certara.ModelResults)
library(xpose)

xpdb <- xpose_data(
  runno = "1",
  prefix = "run",
  ext = ".lst",
  dir = "./NONMEM/Hands_onB/")

resultsUI(xpdb = xpdb)

# Multiple models

xpdb_multiple <- list(
 run1 = xpose_data(file = "run1.lst"),
 run2 = xpose_data(file = "run2.lst"),
 run3 = xpose_data(file = "run3.lst"),
 run4 = xpose_data(file = "run4.lst")
)
}

}
