create_input <- function(InputUnits, mapping) {
  input <- InputUnits$input
  inputColnames <- colnames(input)

  # proceeding with ID
  IDcol <- lookupMappedColumn(inputColnames, mapping, "id")
  if (IDcol[1] == "") {
    stop("Cannot proceed further since ID column(s) not found",
         "\n in the column mapping data.")
  }

  if (length(IDcol) > 1) {
    message("Multiple IDs are detected;",
            "\n Will be concatenated by '_'.")

    if ("ID" %in% colnames(input)) {
      # since we are trying to sort later by IDs,
      # we need to retain an original ID column
      specialIDCortColumn <- "ID_inputSortColumn"
      input[specialIDCortColumn] <- input$ID
      IDcol[which(IDcol == "ID")] <- specialIDCortColumn
    }
  }

  input$ID <-
    as.character(do.call(paste, c(input[IDcol], sep = "_")))

  # adding WhichReset
  input <- .add_whichReset(input, mapping)

  # proceeding with time
  Timecol <-
    lookupMappedColumn(inputColnames, mapping, "time", warn = FALSE)
  if (Timecol == "") {
    message("Time column not found, the model assumed to be non-time based.")
    TimeBased <- FALSE
  } else {
    TimeBased <- TRUE
    input$TIME <- input[[Timecol]]
  }

  list(input = input,
       unitsPresent = InputUnits$unitsPresent,
       optionalUnits = InputUnits$optionalUnits,
       TimeBased = TimeBased,
       IDcol = IDcol)
}
