% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate_plots.R
\name{prm_vs_cov}
\alias{prm_vs_cov}
\title{Parameter vs covariate Plot}
\usage{
prm_vs_cov(
  xpdb,
  covariate,
  mapping = NULL,
  drop_fixed = FALSE,
  group = "ID",
  type = "bpls",
  title = "Parameters vs @x | @run",
  subtitle = "Based on @nind individuals",
  caption = "@dir",
  tag = NULL,
  log = NULL,
  guide = FALSE,
  onlyfirst = FALSE,
  facets,
  .problem,
  quiet,
  ...
)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{covariate}{Character; String of covariate name}

\item{mapping}{List of aesthetics mappings to be used for the xpose plot
(e.g. \code{point_color}).}

\item{drop_fixed}{Logical; logic specifying whether structural parameters having same value
for the given covariate value should be removed from plotting}

\item{group}{Grouping variable to be used for lines. \code{ID} by default}

\item{type}{Character; String setting the type of plot to be used.
Must be 'b' for categorical covariates,
one or a combination of 'p','l','s' for continuous covariates.}

\item{title}{Character; Plot title. Use \code{NULL} to remove.}

\item{subtitle}{Character; Plot subtitle. Use \code{NULL} to remove.}

\item{caption}{Character; Page caption. Use \code{NULL} to remove.}

\item{tag}{Character; Plot identification tag. Use \code{NULL} to remove.}

\item{log}{Character; String assigning logarithmic scale to axes, can be either '',
'x', y' or 'xy'.}

\item{guide}{Logical; Enable guide display (e.g. unity line).}

\item{onlyfirst}{Logical; Should the data be filtered to retain first value for each group/facet.}

\item{facets}{Either a character string to use \code{\link[ggforce]{facet_wrap_paginate}}
or a formula to use \code{\link[ggforce]{facet_grid_paginate}}.}

\item{.problem}{The $problem number to be used. By default returns
the last estimation problem.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}

\item{...}{Any additional aesthetics to be passed on \code{\link[xpose]{xplot_scatter}}
or \code{\link{xplot_box}}.}
}
\value{
An object of class \code{xpose_plot}, \code{ggplot}, and \code{gg}. This object represents a customized plot created using \code{ggplot2}.
The \code{xpose_plot} class provides additional metadata and integration with \code{xpose} workflows, allowing for advanced
customization and compatibility with other \code{xpose} functions. Users can interact with the plot object as they
would with any \code{ggplot2} object, including modifying aesthetics, adding layers, or saving the plot.
}
\description{
Plot Parameters against a continuous or categorical covariate.
}
\section{Layers mapping}{

Plots can be customized by mapping arguments to specific layers. The naming convention is
layer_option where layer is one of the names defined in the list below and option is
any option supported by this layer e.g. boxplot_fill = 'blue', etc.
\itemize{
  \item box plot: options to \code{geom_boxplot}
  \item point plot: options to \code{geom_point}
  \item line plot: options to \code{geom_line}
  \item smooth plot: options to \code{geom_smooth}
  \item xscale: options to \code{scale_x_continuous} or \code{scale_x_log10}
  \item yscale: options to \code{scale_y_continuous} or \code{scale_y_log10}
}
}

\examples{
prm_vs_cov(xpose::xpdb_ex_pk,
  covariate = "AGE", type = "ps",
  log = "y",
  yscale_breaks = scales::trans_breaks("log10", function(x) 10^x),
  yscale_labels = scales::trans_format("log10", scales::math_format(10^.x)),
  caption = NULL
)

prm_vs_cov(xpose::xpdb_ex_pk,
  covariate = "SEX",
  type = "b",
  boxplot_fill = "blue",
  boxplot_color = "black",
  boxplot_outlier.color = "red"
)

}
\seealso{
\code{\link[xpose]{xplot_scatter}} \code{\link{xplot_box}}
}
