\name{axialnntsdensity}
\alias{axialnntsdensity}
\title{
NNTS density function for axial data
}
\description{
Density function for the NNTS axial model}
\usage{
axialnntsdensity(data, cpars = 1/sqrt(pi), M = 0)
}
\arguments{
  \item{data}{Vector of size R with axial angles in radians}
  \item{cpars}{Vector of complex numbers of dimension M+1. The first element is a real and positive number. The sum of the squared moduli of the c parameters must be equal to 1/pi}
  \item{M}{Number of components in the NNTS axial model}
}
\value{
\item{res}{The function returns a 1 by R matrix with the density function evaluated at each element of the vector data of size R}
}
\author{
Juan Jose Fernandez-Duran and Maria Mercedes Gregorio-Dominguez
}
\references{
Fernandez-Duran, J.J. and Gregorio-Dominguez, M.M. (2025). Multimodal distributions for circular axial data. arXiv:2504.04681 [stat.ME] (available at https://arxiv.org/abs/2504.04681)
}
\examples{
ccoef<-axialnntsrandominitial(3)
axialnntsdensity(1,ccoef,3)
axialnntsdensity(pi/2,ccoef,3)
axialnntsdensity(c(1,pi/2),ccoef,3)
}
