% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_root_time.R
\name{fix_root_time}
\alias{fix_root_time}
\title{Fixes root.time after taxa have been pruned from a tree}
\usage{
fix_root_time(original_tree, pruned_tree)
}
\arguments{
\item{original_tree}{A tree in phylo format.}

\item{pruned_tree}{A tree in phylo format that represents a pruned version of \code{original_tree}.}
}
\value{
Returns a tree (phylo object) with a fixed \code{$root.time}.
}
\description{
Fixes root.time after taxa have been pruned from a tree using ape::drop.tip
}
\details{
(NB: This function is designed to only cope with trees containing at least three tips.)

When removing taxa from a time-scaled tree using \link[ape]{drop.tip} in \link[ape]{ape} \code{$root.time} is left unchanged. This can cause downstream problems if not fixed and that is what this function does.

Note that \code{fix_root_time} in the \code{paleotree} package performs the same function, but is not called here to reduce the number of libraries on which \code{Claddis} is dependent. Interested users should also refer to the \code{dropPaleoTip} function in \code{paleotree}.
}
\examples{

# Create a simple four-taxon tree with branch lengths:
tree <- ape::read.tree(text = "(A:1,(B:1,(C:1,D:1):1):1);")

# Set root age as 20 Ma:
tree$root.time <- 20

# Now prune taxon A:
pruned_tree <- ape::drop.tip(phy = tree, tip = "A")

# Show that drop.tip has not updated the tree's root time:
pruned_tree$root.time

# Use the function to fix the root time:
pruned_tree <- fix_root_time(original_tree = tree, pruned_tree = pruned_tree)

# Show that the root time is now fixed (19 Ma):
pruned_tree$root.time
}
\seealso{
\link{drop_time_tip}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
