% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_all_uncertainties.r
\name{permute_all_uncertainties}
\alias{permute_all_uncertainties}
\title{Permute all possible uncertainties for a given set of states}
\usage{
permute_all_uncertainties(single_states)
}
\arguments{
\item{single_states}{A vector of single states (e.g., 0, 1, 2 etc.).}
}
\value{
A vector of all possible uncertainty states.
}
\description{
Given a set of discrete states, will permute all possible uncertainity combinations of those states.
}
\details{
This function solves a simple phylogenetic combinatorics problem - what are all the possible outcomes for a character to be in given uncertainties are allowed?

For example, for three states (0, 1, 2) there are four possible uncertainties: 0/1, 0/2, 1/2 and 0/1/2.

If the user is instead only interested in the size of this state space, this is simply given by 2^N - N - 1, where N is the number of single states. Thus, the first several outcomes are:

\preformatted{----------------------------------
| N states | N possible outcomes |
----------------------------------
|     2    |          1          |
|     3    |          4          |
|     4    |          11         |
|     5    |          26         |
|     6    |          57         |
|     7    |          120        |
|     8    |          247        |
|     9    |          502        |
|    10    |          1,013      |
|    11    |          2,036      |
|    12    |          4,083      |
|    13    |          8,178      |
|    14    |          16,369     |
----------------------------------}

Note that this function is really designed for internal use, but may have value to some users and so is available "visibly" here.
}
\examples{

# Get all possible states for the character 0, 1, and 2:
permute_all_uncertainties(single_states = 0:2)

}
\seealso{
\link{make_costmatrix} and \link{permute_all_polymorphisms}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
