% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv04_histogram_kde.R
\name{cv04_histogram_kde}
\alias{cv04_histogram_kde}
\title{Plot Histogram with Kernel Density Estimate Curve}
\usage{
cv04_histogram_kde(data, residue_pct_col)
}
\arguments{
\item{data}{A dataframe containing the relevant dataset.}

\item{residue_pct_col}{The name of the column in `data` that contains the residue percentages.}
}
\value{
A ggplot object representing the histogram with KDE curve.
}
\description{
This function takes a dataset and a column representing the residue percentages
and generates a histogram overlaid with a KDE (Kernel Density Estimate) curve.
It calculates and marks quantiles P0.5, P0.8413, P0.9772, and the P0.99865, i.e., UCL (Upper Control Limit)
on the plot.
}
\examples{
Eq_DAR <- cv03_usl_unification(data=Eq_DAR,"CleaningEvent", "DAR", usl_col="USL")
cv04_histogram_kde(data = Eq_DAR, residue_pct_col = "DAR_Pct")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
