% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv10_dunn_test_vs_control.R
\name{cv10_dunn_test_vs_control}
\alias{cv10_dunn_test_vs_control}
\title{Dunn's Test for Residue}
\usage{
cv10_dunn_test_vs_control(data, residue_col, cleaning_event_col)
}
\arguments{
\item{data}{A data frame containing the data.}

\item{residue_col}{The name of the column containing residue.}

\item{cleaning_event_col}{The name of the column containing cleaning event identifiers.}
}
\value{
A data frame of Dunn's test results with control group.
}
\description{
Perform Dunn's test for residue based on cleaning events. Choose the control
group as the cleaning event whose median is closest to the grand median. This
function is for investigation purpose.
}
\examples{
# 'Eq_DAR' is the  data frame, 'DAR_Pct' is the residue column, and
# 'CleaningEvent' is the cleaning event column.
Eq_DAR <- cv03_usl_unification(data = Eq_DAR, residue_col = "DAR",
cleaning_event_col = "CleaningEvent",  usl_col = "USL")
dunn_test_results_vs_control <- cv10_dunn_test_vs_control(data = Eq_DAR,
residue_col = "DAR_Pct", cleaning_event_col = "CleaningEvent")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
