% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv30_dar_car_mic_ppu.R
\name{cv30_dar_car_mic_ppu}
\alias{cv30_dar_car_mic_ppu}
\title{Calculate DAR, CAR, and Mic Ppu Values and Identify the Overall Minimum}
\usage{
cv30_dar_car_mic_ppu(
  dar_data,
  dar_residue_col,
  dar_cleaning_event_col,
  dar_usl_col,
  car_data,
  car_residue_col,
  car_cleaning_event_col,
  car_usl_col,
  mic_data,
  mic_residue_col,
  mic_cleaning_event_col,
  mic_usl_col
)
}
\arguments{
\item{dar_data}{A dataframe containing DAR data.}

\item{dar_residue_col}{The name of the DAR residue column.}

\item{dar_cleaning_event_col}{The name of the DAR cleaning event identifier column.}

\item{dar_usl_col}{The name of the DAR Upper Specification Limit column.}

\item{car_data}{A dataframe containing CAR data.}

\item{car_residue_col}{The name of the CAR residue column.}

\item{car_cleaning_event_col}{The name of the CAR cleaning event identifier column.}

\item{car_usl_col}{The name of the CAR Upper Specification Limit column.}

\item{mic_data}{A dataframe containing Mic data.}

\item{mic_residue_col}{The name of the Mic residue column.}

\item{mic_cleaning_event_col}{The name of the Mic cleaning event identifier column.}

\item{mic_usl_col}{The name of the Mic Upper Specification Limit column.}
}
\value{
A dataframe with Ppu values for DAR, CAR, and Mic, along with the Overall Minimum Ppu.
}
\description{
This function calculates Ppu values for DAR, CAR, and Mic using the KDE method provided by the `cv12_kde_ppu` function. It then uses the `cv29_mic_ppu` function to calculate combined Ppu for Mic and extract the method with the minimum Ppu value. The function assumes the availability of the datasets `Eq_DAR`, `Eq_CAR`, and `Eq_Mic` that conform to expected column naming conventions and data structures. It is reliant on the results of the `cv12_kde_ppu` and `cv29_mic_ppu` functions being consistent and correctly formatted.
}
\examples{
\donttest{
Eq_DAR <- cv03_usl_unification(data = Eq_DAR, cleaning_event_col = "CleaningEvent", 
 residue_col = "DAR", usl_col = "USL")
 Eq_CAR <- cv03_usl_unification(data = Eq_CAR, cleaning_event_col = "CleaningEvent", 
 residue_col = "CAR", usl_col = "USL")
  df1 <- cv30_dar_car_mic_ppu(
    dar_data = Eq_DAR, 
    dar_residue_col = "DAR_Pct", 
    dar_cleaning_event_col = "CleaningEvent", 
    dar_usl_col = "USL_Pct",
    car_data = Eq_CAR, 
    car_residue_col = "CAR_Pct", 
    car_cleaning_event_col = "CleaningEvent", 
    car_usl_col = "USL_Pct",
    mic_data = Eq_Mic, 
    mic_residue_col = "Mic", 
    mic_cleaning_event_col = "CleaningEvent", 
    mic_usl_col = "USL")
}
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande  [xiande.yang at gmail.com]
}
