% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{bi}
\alias{bi}
\title{Budyko Index}
\usage{
bi(data, pr, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{data}{net radiation, J/m2}

\item{pr}{daily precipitation, mm}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{further arguments passed to or from other methods}
}
\value{
index value
}
\description{
Budyko Index is based on characteristics of the surface heat and water balance.
}
\section{Formula}{
 \deqn{BI = 100\frac {Rn}{L*P}} Rn= annual net radiation, P = annual precipitation, L = latent heat of vaporization for water
}

\examples{
data(data_all)
bi(data = data_all$radiation, pr = data_all$rr)
}
\references{
Budyko M.I. The Heat Balance of the Earth's Surface U.S. Department of Commerce, Washington D.C (1958) 259 pp., translated by N.A. Stepanova
}
