% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\docType{class}
\name{Clustering-class}
\alias{Clustering-class}
\alias{Clustering}
\title{The Clustering Class}
\description{
A class containing relevant data for comparing clusterings,
including the affinity matrix for the Clustering.
}
\section{Slots}{

\describe{
\item{\code{names}}{A character vector of element names; will be 1:n_elements if no
names were available when creating the Clustering object.}

\item{\code{n_elements}}{A numeric giving the number of elements.}

\item{\code{is_hierarchical}}{A logical indicating whether the clustering is
hierarchical or flat.}

\item{\code{is_disjoint}}{A logical indicating whether the clustering is disjoint or
overlapping.}

\item{\code{alpha}}{A numeric giving the personalized PageRank damping factor;
1 - alpha is the restart probability for the PPR random walk.}

\item{\code{r}}{A numeric hierarchical scaling parameter.}

\item{\code{elm2clu_dict}}{A list giving the clusters each element is a member of.}

\item{\code{clu2elm_dict}}{A list giving the element members of each cluster.}

\item{\code{affinity_matrix}}{A Matrix containing the personalized pagerank
equilibrium distribution.}
}}

\keyword{internal}
