% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-app.R
\name{write_objects}
\alias{write_objects}
\title{Write the objects for the ClustAssess ShinyApp}
\usage{
write_objects(
  clustassess_object,
  expression_matrix,
  metadata,
  project_folder = ".",
  compression_level = 6,
  chunk_size = 100,
  gene_variance_threshold = 0,
  summary_function = stats::median,
  qualpalr_colorspace = "pretty"
)
}
\arguments{
\item{clustassess_object}{The output of the ClustAssess automatic pipeline}

\item{expression_matrix}{The expression matrix}

\item{metadata}{The metadata}

\item{project_folder}{The folder where the files will be written}

\item{compression_level}{The compression level for the h5 files (See `rhdf5::h5createFile`` for more details)}

\item{chunk_size}{The chunk size for the rank matrix (See \code{rhdf5::h5createDataset} for more details)}

\item{gene_variance_threshold}{The threshold for the gene variance; genes with variance below this threshold will be removed}

\item{summary_function}{The function used for summarizing the stability values; the default is \code{median}}

\item{qualpalr_colorspace}{The colorspace used for generating the colors; the default is \code{pretty}}
}
\value{
NULL (the files are written in the project_folder)
}
\description{
Given the output of the ClustAssess pipeline, the expression matrix
and the metadata, this function creates the files needed for the ClustAssess
ShinyApp. The files are written in the project_folder and are the following:
\itemize{
\item metadata.rds: the metadata file
\item stability.h5: contains the stability results
\item expression.h5: contains the expression matrix and the rank matrix
}
}
