% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgc.R
\name{dgc_test}
\alias{dgc_test}
\title{Di Rienzo, Guzman and Casanoves test for multiple comparisons}
\usage{
dgc_test(
  y,
  trt,
  alpha = 0.05,
  show_plot = TRUE,
  console = TRUE,
  abline_options,
  ...
)
}
\arguments{
\item{y}{Either a model (created with \code{lm()} or \code{aov()}) or a numerical
vector with the values of the response variable for each unit.}

\item{trt}{If \code{y} is a model, a string with the name of the column containing
the treatments. If \code{y} is a vector, a vector of the same length as \code{y}
with the treatments for each unit.}

\item{alpha}{Value equivalent to 0.05 or 0.01, corresponding to the
significance level of the test. The default value is 0.05.}

\item{show_plot}{Logical value indicating whether the constructed dendrogram
should be plotted or not.}

\item{console}{Logical value indicating whether the results should be printed
on the console or not.}

\item{abline_options}{\code{list} with optional arguments for the line in the
dendrogram.}

\item{...}{Optional arguments for the \code{plot()} function.}
}
\value{
A list with three \code{data.frame} and one \code{hclust}:
\item{stats}{\code{data.frame} containing summary statistics by treatment.}
\item{groups}{\code{data.frame} indicating the group to which each treatment is
assigned.}
\item{parameters}{\code{data.frame} with the values used for the test.
\code{treatments} is the total number of treatments, \code{alpha} is the
significance level used, \code{c} is the cut-off criterion for the dendrogram
(the height of the horizontal line on the dendrogram), \code{q} is the
\eqn{1 - \alpha} quantile of the distribution of \eqn{Q} (distance from
the root node) under the null hypothesis and \code{SEM} is an estimate of the
standard error of the mean.}
\item{dendrogram_data}{object of class \code{hclust} with data used to build
the dendrogram.}
}
\description{
Di Rienzo, Guzman and Casanoves (DGC) test for multiple comparisons.
Implements a cluster-based method for identifying groups of nonhomogeneous
means. Average linkage clustering is applied to a distance matrix obtained
from the sample means. The distribution of \eqn{Q} (distance between the
source and the root node of the tree) is used to build a test with a
significance level of \eqn{\alpha}. Groups whose means join above
\eqn{c} (the \eqn{\alpha}-level cut-off criterion) are statistically
different.
}
\examples{
data("PlantGrowth")
# Using vectors -------------------------------------------------------
weights <- PlantGrowth$weight
treatments <- PlantGrowth$group
dgc_test(y = weights, trt = treatments, show_plot = FALSE)
# Using a model -------------------------------------------------------
model <- lm(weights ~ treatments)
dgc_test(y = model, trt = "treatments", show_plot = FALSE)
}
\references{
Di Rienzo, J. A., Guzman, A. W., & Casanoves, F. (2002). A
Multiple-Comparisons Method Based on the Distribution of the Root Node
Distance of a Binary Tree. \emph{Journal of Agricultural, Biological, and
Environmental Statistics, 7}(2), 129-142.
<jstor.org/stable/1400690>
}
\author{
Santiago Garcia Sanchez
}
