% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.clusbootglm.R
\name{coef.clusbootglm}
\alias{coef.clusbootglm}
\title{Obtain coefficients from cluster bootstrap object}
\usage{
\method{coef}{clusbootglm}(object, estimate.type = "bootstrap", ...)
}
\arguments{
\item{object}{object of class \code{clusbootglm}.}

\item{estimate.type}{type of coefficient (\code{bootstrap} or \code{GLM}).}

\item{...}{other arguments.}
}
\description{
Returns the coefficients of an object of class \code{clusbootglm}.
}
\examples{
\dontrun{
data(opposites)
cbglm.1 <- clusbootglm(SCORE~Time*COG,data=opposites,clusterid=Subject)
coef(cbglm.1, estimate.type="bootstrap")}
}
\author{
Mathijs Deen
}
