% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TauAndParameters_EstParmFunc_FBM.R
\name{TauAndParameters_EstParmFunc_FBM}
\alias{TauAndParameters_EstParmFunc_FBM}
\title{Obtaining the value of tau and the estimate value of the rest of the parameters}
\usage{
TauAndParameters_EstParmFunc_FBM(
  ttau = 30,
  ridge.final,
  Iter.EstParmFunc = 80,
  especie,
  EspecieMaxima,
  Tt,
  E,
  seed = NULL
)
}
\arguments{
\item{ttau}{Number. We estimate de FBM model for the values of tau: 1, 2,..., ttau}

\item{ridge.final}{Object of class "ridgelm". Values obtained with the ridge regression.}

\item{Iter.EstParmFunc}{Number. Number of iterations. Default: 80 iterations.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points. The bacteria placed in the last row of the matrix will be used as reference in the alr transformation and will be at the denominator of the balance.}

\item{EspecieMaxima}{Row in which the bacteria used as reference is in \code{especie}. This is the bacteria that is going to be at the denominator of the balance and at the denominator of the alr transformartion. As a result, in this function, \code{EspecieMaxima} must be equal to \code{E}}

\item{Tt}{Number of time points available}

\item{E}{Number. Number of bacteria available.}

\item{seed}{Number. Set a seed. Default \code{seed=NULL}.}
}
\value{
Returns a list with:
\itemize{
  \item EstimateParameters:  Vector with the estimated parameters, in the following order: a11,a12,a13, a21, a22,a23, ...a(D-1)1,a(D-1)2,a(D-1)3,tau. Where D is the number of bacterial species present in the matrix \code{especie}.
  \item AIC Number: Value of the AIC.
 \item All.iter:  Matrix. Each row has the parameters obtained in each iteration. The parameters are in the columns written in the same order that they are written in \code{Param.Estimates }. In this matrix we must observe that in the last iterations the values has really similar or equal values, if not, we need to increase the value of \code{Iter.EstParmFunc}.

  }
}
\description{
This function estimates the parameters of the FBM model.
}
\details{
We give to the parameter tau the value 1,2,...,\code{ttau}. We estimate the FBM model for all this values (using the function "Estimate_param_FBM")
and we select the value of tau that minimizes the AIC. The regression of this model is defined by

\deqn{\mu_{it}=a_{i1}+a_{i2}\cdot\text{alr}(x_{i,(t-1)})+a_{i3}\cdot\text{Balance}(x_{i,(t-1)})\text{ for }i=1,\dots, D-1\text{ where } D \text{ is the number of bacteria}}
}
\examples{

set.seed(123)
especie=t(gtools::rdirichlet(5,c(1,3,1)))
Tt=5
E=3
EspecieMaxima=3
ridge.final=ridgeregression(Tt,especie, E, EspecieMaxima)
ttau=10
Iter.EstParmFunc=10

TauAndParameters_EstParmFunc_FBM(ttau,ridge.final,Iter.EstParmFunc, especie,EspecieMaxima,Tt,E,714)
}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2021). A Dirichlet autoregressive model for the analysis of microbiota time-series data. Complexity, 2021, 1-16.
}
