% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtp.R
\name{mtp}
\alias{mtp}
\title{The modified Townsend function}
\usage{
mtp(x1, x2)
}
\arguments{
\item{x1}{A scalar value between -2.25 and 2.5, inclusive}

\item{x2}{A scalar value between -2.5 and 1.75, inclusive}
}
\value{
The evaluation of running the modified Townsend function at input pair (x1, x2).
\itemize{
  \item obj:  A scalar objective function value
  \item con:  A scalar constraint function value
}
}
\description{
This function evaluates the objective and constraint functions for the modified Townsend function.
}
\note{
A solution is feasible when the constraint function is less than or equal to 0.
}
\examples{
### Running the modified Townsend function at x1 = 1 and x2 = 0.8
### obj = 0.9073035 and con = 2.012166
### (x1,x2) = (1,1) is not a feasible solution

mtp(1,1)
}
