% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth_structure.R
\name{depth_structure}
\alias{depth_structure}
\alias{depth_structure.cfp_layered_profile}
\alias{depth_structure.cfp_profile}
\alias{depth_structure.cfp_dat}
\title{Unique layers depths}
\usage{
depth_structure(x, id_cols = NULL, ...)

\method{depth_structure}{cfp_layered_profile}(x, id_cols = NULL, ...)

\method{depth_structure}{cfp_profile}(x, id_cols = NULL, ...)

\method{depth_structure}{cfp_dat}(x, id_cols = NULL, structure_from = NULL, ...)
}
\arguments{
\item{x}{An object to get general structure of.}

\item{id_cols}{The columns that identify each set of depth structures
to extract (e.g. a site identifier).}

\item{...}{internal
One of \code{"gasdata"} \code{"soilphys"} or \code{"layers_map"}.}

\item{structure_from}{From which element should the structure be returned?}
}
\value{
A \link{cfp_profile} with columns depth, or upper and lower.
}
\description{
Get the unique layers or depths, i.e. the backbone
of an object given a set of identifying columns.
}
\examples{
depth_structure(cfp_soilphys(ConFluxPro::base_dat))
depth_structure(cfp_gasdata(ConFluxPro::base_dat))

}
