% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvariantEnvironmentPrediction.R
\name{InvariantEnvironmentPrediction}
\alias{InvariantEnvironmentPrediction}
\title{Invariant environment prediction.}
\usage{
InvariantEnvironmentPrediction(Y, E, X, alpha = 0.05, verbose = FALSE,
  trainTestSplitFunc = caTools::sample.split,
  argsTrainTestSplitFunc = list(Y = E, SplitRatio = 0.8),
  test = propTestTargetE, mtry = sqrt(NCOL(X)), ntree = 100,
  nodesize = 5, maxnodes = NULL, permute = TRUE,
  returnModel = FALSE)
}
\arguments{
\item{Y}{An n-dimensional vector.}

\item{E}{An n-dimensional vector. If \code{test = propTestTargetE}, E needs
to be a factor.}

\item{X}{A matrix or dataframe with n rows and p columns.}

\item{alpha}{Significance level. Defaults to 0.05.}

\item{verbose}{If \code{TRUE}, intermediate output is provided. Defaults to \code{FALSE}.}

\item{trainTestSplitFunc}{Function to split sample. Defaults to stratified sampling
using \code{caTools::sample.split}, assuming E is a factor.}

\item{argsTrainTestSplitFunc}{Arguments for sampling splitting function.}

\item{test}{Unconditional independence test that tests whether the out-of-sample
prediction accuracy is the same when using X only vs. X and Y as predictors for E.
Defaults to \code{propTestTargetE}.}

\item{mtry}{Random forest parameter: Number of variables randomly sampled as
candidates at each split.  Defaults to \code{sqrt(NCOL(X))}.}

\item{ntree}{Random forest parameter: Number of trees to grow. Defaults to 100.}

\item{nodesize}{Random forest parameter: Minimum size of terminal nodes. Defaults to 5.}

\item{maxnodes}{Random forest parameter: Maximum number of terminal nodes trees in the forest can have.
Defaults to \code{NULL}.}

\item{permute}{Random forest parameter: If \code{TRUE}, model that would use X only
for predicting Y also includes a random permutation of E. Defaults to \code{TRUE}.}

\item{returnModel}{If \code{TRUE}, the fitted quantile regression forest model
will be returned. Defaults to \code{FALSE}.}
}
\value{
A list with the following entries:
\itemize{
 \item \code{pvalue} The p-value for the null hypothesis that Y and E are independent given X.
 \item \code{model} The fitted models if \code{returnModel = TRUE}.
 }
}
\description{
Tests the null hypothesis that Y and E are independent given X.
}
\examples{
# Example 1
n <- 1000
E <- rbinom(n, size = 1, prob = 0.2)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * (X)^2 + rnorm(n)
InvariantEnvironmentPrediction(Y, as.factor(E), X)

# Example 2
E <- rbinom(n, size = 1, prob = 0.2)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * E + rnorm(n)
InvariantEnvironmentPrediction(Y, as.factor(E), X)

# Example 3
E <- rnorm(n)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * (X)^2 + rnorm(n)
InvariantEnvironmentPrediction(Y, E, X, test = wilcoxTestTargetY)
InvariantEnvironmentPrediction(Y, X, E, test = wilcoxTestTargetY)
}
