#' Utility function
#'
#' Utility function to use to set the control arguments of \code{kunfolding}
#'
#' @param model Specifies MDS model. One among "ordnal (default)" or "metric"
#' @param init Initial configuration. One among "torgerson" (degault), "random" or "user"
#' @param transf The transformation. One among "primary" (default), "secondary","tertiary","spline","ratio","interval","none"
#' @param userinit The user initial configuration if "init" has been set as "user"
#' @param w The set of weigths. Default: NULL
#' @param minstress the minimum stress (for stress method). Default 1e-5
#' @param itermax Maximum number if iterations. Default 500
#' @param printscr Display the summary of the model. Default TRUE
#' @param spline.degree Degree of spline transformation. Default 2 
#' @param spline.intKnots Interior knots. default 2
#' @param relax Relax the solution. Default FALSE
#' @param modulus Modulus. Default 1
#' 
#' @return A list containing all the control parameters
#' 
#' 
#' @author Antonio D'Ambrosio \email{antdambr@unina.it}
#' 
#' @seealso  \code{\link{kunfolding}} 
#' 
#' @export


mdscontrol <- function(model = "ordinal",
                       init = "torgerson",
                       transf="primary",
                       userinit = NULL,
                       w = NULL,
                       minstress = 1e-5,
                       itermax = 500,
                       printscr = TRUE,
                       spline.degree = 2, 
                       spline.intKnots = 2,
                       relax = FALSE,
                       modulus = 1)
{
  
  return(list(model = model, init = init, transf = transf, w = w, 
              minstress = minstress, itermax = itermax,
              printscr=printscr, spline.degree=spline.degree, spline.intKnots=spline.intKnots,
              relax=relax, modulus=modulus))
  
}