% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validatetree.R
\name{validatetree}
\alias{validatetree}
\title{Validation of the tree for preference rankings}
\usage{
validatetree(
  Tree,
  testX = NULL,
  testY = NULL,
  method = "test",
  V = 5,
  plotting = TRUE
)
}
\arguments{
\item{Tree}{An object of the class "ranktree" coming form the function \code{ranktree}}

\item{testX}{The data frame containing the test set (predictors)}

\item{testY}{The matrix obtaining the test set (response)}

\item{method}{One between "test" (default) or "cv"}

\item{V}{The cross-validation parameter. Default V=5}

\item{plotting}{With the default option plotting=TRUE, the pruning sequence plot is visualized}
}
\value{
A list containing:
\tabular{lll}{
tau \tab \tab the Tau_x rank correlation coefficient of the sequence of the trees\cr
error \tab  \tab the error of the sequence of the trees\cr
termnodes\tab \tab the number of terminal nodes of the sequence of the trees\cr
best_tau \tab \tab the best tree in terms of Tau_x rank correlation coefficient\cr
best_error \tab \tab the best tree in terms of error (it is the same)\cr
validation \tab \tab information about the validation procedure}
}
\description{
Validation of the tree either with a test set procedure or with v-fold cross validation
}
\examples{
\donttest{
data(EVS)
EVS$rankings[is.na(EVS$rankings)] <- 3
set.seed(654)
training=sample(1911,1434)
tree <- ranktree(EVS$rankings[training,],EVS$predictors[training,],decrmin=0.001,num=50)
#test set validation
vtreetest <- validatetree(tree,testX=EVS$predictors[-training,],EVS$rankings[-training,]) 
#cross-validation
vtreecv <- validatetree(tree,method="cv",V=10) 
}

}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
