% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bisect.R
\name{Bisect}
\alias{Bisect}
\title{Bisections for finding a root of a function}
\usage{
Bisect(ffnc, intrv, tol = 1e-08)
}
\arguments{
\item{ffnc}{an increasing function of a single scalar argument}

\item{intrv}{an interval over which the root of ffnc is sought}

\item{tol}{a tolerance determining when the successive bisections of the interval within which the root will lie have become small enough to stop}
}
\value{
This function returns a vector consisting of two numbers. The first named root is an estimate of the root x  solving ffnc(x) = 0, valid within an error of tol.
The second output vector element named fval is the value of the function ffnc at root.
It should be very close to 0 unless the function happens to jump from a value less than 0 to a value greater than 0 at  root.
}
\description{
Find a root of a function by the method of Bisections
}
\details{
This function finds the root of the increasing function ffnc over the scalar interval intrv by the Method of Bisections. The function must be increasing but need not be smooth, and it must have a negative sign (value less than -tol) at the left endpoint of  intrv  and positive sign (value greater than tol) at the right endpoint. The method of Bisection is used in successive iterations to successively halve the width of the interval in which the root lies.
}
\examples{
Bisect(function(x) x^2-1, c(0,2),1e-8)
}
\references{
to be added
}
\author{
Eric Slud
}
