% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GameVector.R
\name{getZeroOneNormalizedGameVector}
\alias{getZeroOneNormalizedGameVector}
\title{Compute 0-1-normalized game vector}
\usage{
getZeroOneNormalizedGameVector(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Numeric vector of length (2^n)-1 representing the zero-one-normalized game.
}
\description{
Computes the zero-one-normalized game for a given game specified by a game vector.
}
\examples{
library(CoopGame)
v<-c(1:7)
getZeroOneNormalizedGameVector(v)

}
\references{
Gilles R. P. (2015)  \emph{The Cooperative Game Theory of Networks and Hierarchies}, Springer, p. 18

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 670
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
