% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copc1.r
\name{condQestCopC}
\alias{condQestCopC}
\title{Conditional Quantile Estimation}
\usage{
condQestCopC(tao,Yc,d,delta,copula,cop=NULL,theta=NULL,nIS=10000,
MARGIN=NULL,MARGIN.inv=NULL,...)
}
\arguments{
\item{tao}{the desired quantile level, a numeric value between 0 and 1.}

\item{Yc}{the Nx1 vector of observed responses that are subject to lower detection limit.}

\item{d}{the lower detection limit.}

\item{delta}{the Nx1 vector of censoring indicator
with 1 indicating uncensored and 0 indicating left censored.}

\item{copula}{the input copula object with copula parameter plugged in.
If specified, \code{cop} and \code{theta} can be omitted.}

\item{cop}{the choice of copula function.
There are currently five available copula funcitons,
including Clayton copula, Gaussian copula, Gumbel copula, Joe copula and Frank copula.
Specify one from "Clayton","Gaussian","Gumbel","Joe" and "Frank".}

\item{theta}{the copula parameter.}

\item{nIS}{the size for sequential importance sampling.
The default is 10000.}

\item{MARGIN}{the marginal distribution of the latent time series.}

\item{MARGIN.inv}{the inverse marginal distribution of the latent time series.}

\item{...}{additional parameters for the marginal distribution of the latent time series.}
}
\value{
\code{condQestCopC} returns the conditional tao-th quantile of Y_{n+1} given {Y1,...,Yn}
based on the specified copula function and marginal distribution.
}
\description{
Given estiamted copula with copula parameter and specified marginal distribution,
obtain the conditional qth quantile of Y_{n+1} given {Y1,...,Yn}.
}
\examples{
set.seed(20)
Y = genLatentY(cop = "Clayton", theta = 1, N = 30)
d = -0.5
delta = (Y>d)
Yc = pmax(d,Y)
cq60.real = condQestCopC(0.6,Yc,d,delta,copula=claytonCopula(1),nIS = 50,
                        MARGIN=pnorm,MARGIN.inv=qnorm)
### Use selected copula
selCopC = selectCopC(cop.type = c("Clayton","Frank"),Yc,d,delta,nIS=50)
cq60.est = condQestCopC(0.6,Yc,d,delta,selCopC$Selected,nIS=50)
}
\references{
Li, F., Tang, Y. and Wang, H. (2018).
Copula-Based Semiparametric Analysis for Time Series Data with Detection Limits, technical report.
}
