% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_est.R
\name{standard_est}
\alias{standard_est}
\title{Computes the Standard Estimator of the Autocovariance Function.}
\usage{
standard_est(
  X,
  pd = TRUE,
  maxLag = length(X) - 1,
  type = "autocovariance",
  meanX = mean(X)
)
}
\arguments{
\item{X}{A vector representing observed values of the time series.}

\item{pd}{Whether a positive-definite estimate should be used. Defaults to \code{TRUE}.}

\item{maxLag}{An optional parameter that determines the maximum lag to compute the estimated autocovariance function at. Defaults to \code{length(X) - 1}.}

\item{type}{Compute either the 'autocovariance' or 'autocorrelation'. Defaults to 'autocovariance'.}

\item{meanX}{The average value of \code{X}. Defaults to \code{mean(X)}.}
}
\value{
A vector whose values are the autocovariance estimates.
}
\description{
This function computes the following two estimates of the autocovariance function depending on
the parameter \code{pd}.
}
\details{
For \code{pd = TRUE}:
\deqn{
\widehat{C}(h) = \frac{1}{N} \sum_{j=1}^{N-h} ( X(j) - \bar{X} ) ( X(j + h) - \bar{X} ) .
}

For \code{pd = FALSE}:
\deqn{
\widehat{C}(h) = \frac{1}{N - h} \sum_{j=1}^{N-h} ( X(j) - \bar{X} ) ( X(j + h) - \bar{X} ) .
}

This function will generate autocovariance values for lags \eqn{h} from the set \eqn{\{0, \dots, \mbox{maxLag}\}.}

The positive-definite estimator must be used cautiously when estimating over all lags as the sum of all values of the autocorrelation function equals to \eqn{-1/2}.
For the nonpositive-definite estimator a similar constant summation property holds.
}
\examples{
X <- c(1, 2, 3)
standard_est(X, pd = FALSE, maxLag = 2, meanX = mean(X))
}
\references{
Bilchouris, A. & Olenko, A (2025). On Nonparametric Estimation of Covariogram. Austrian Statistical Society 54(1), 112-137. https://doi.org/10.17713/ajs.v54i1.1975
}
