% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curriculum_graph_from_list.R
\name{curriculum_graph_from_list}
\alias{curriculum_graph_from_list}
\title{Create Curriculum Graph Object}
\usage{
curriculum_graph_from_list(node_list, edge_list)
}
\arguments{
\item{node_list}{Dataframe with an 'id' column for each node and a
'term' column specifying which term the course is to be taken in.}

\item{edge_list}{Dataframe with two columns 'from' and 'to' specifying
directed edges starting at 'from' nodes directed towards 'to' nodes. Entries
must use node ids from \code{node_list}.}
}
\value{
A list that contains the following: \item{node_list}{A dataframe of
course nodes containing their id, term, blocking factor (bf), delay
factor (df), centrality (cf), and cruciality (sc)} \item{edge_list}{A
dataframe with two columns 'from' and 'to' specifying directed edges
starting at 'from' nodes directed towards 'to' nodes.} \item{network}{Igraph
network object representing the curriculum graph} \item{sc_total}{Total
structural complexity of the curriculum graph} \item{bf_total}{Total
blocking factor of the curriculum graph} \item{df_total}{Total delay factor
of the curriculum graph}
}
\description{
Generates a curriculum graph from a node and edge list.
}
\examples{
edge_list <- data.frame(from = c(1, 3), to = c(3, 4))
# courses in node list must be placed sequentially in term order to be properly displayed
node_list <-
data.frame(
 id = 1:4,
 label = c("MATH 100", "DATA 101", "MATH 101", "MATH 221"),
 term = c(1, 1, 2, 2)
)
C <- curriculum_graph_from_list(node_list,edge_list)
plot_curriculum_graph(C)
}
\references{
Heileman, Gregory L, Chaouki T Abdallah, Ahmad Slim, and Michael
Hickman. 2018. “Curricular Analytics: A Framework for Quantifying the Impact
of Curricular Reforms and Pedagogical Innovations.” arXiv Preprint
arXiv:1811.09676.
}
\author{
Daniel Krasnov
}
