% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internals.R
\name{DDIwR_internal}
\alias{DDIwR_internal}
\alias{ascii}
\alias{changeXMLang}
\alias{checkArgument}
\alias{checkDots}
\alias{checkElement}
\alias{checkExisting}
\alias{checkType}
\alias{checkXMList}
\alias{cleanup}
\alias{coerceDDI}
\alias{collectMetadata}
\alias{collectRMetadata}
\alias{extractData}
\alias{formatExample}
\alias{generateID}
\alias{getDateTime}
\alias{getDelimiter}
\alias{getDNS}
\alias{getEnter}
\alias{getFiles}
\alias{getFormat}
\alias{getHashes}
\alias{getValues}
\alias{getXML}
\alias{hasLabels}
\alias{hasMissingLabels}
\alias{makeLabelled}
\alias{missingValuesSPSS}
\alias{prespace}
\alias{removeExtra}
\alias{repeatSpace}
\alias{replaceChars}
\alias{replaceTicks}
\alias{splitrows}
\alias{treatPath}
\alias{writeMetadata}
\alias{XMLtoRmetadata}
\alias{makeNotes}
\alias{getMetadata}
\alias{exportDDI}
\alias{writeRlist}
\title{DDIwR internal functions}
\usage{
ascii(x)

changeXMLang(x, remove = FALSE)

checkArgument(argument, default, length = 1, ...)

checkDots(dotsvalue, default, length = 1)

checkElement(x)

checkExisting(xpath, inside, attribute = NULL)

checkType(x, labels = NULL, na_values = NULL, na_range = NULL)

checkXMList(xmlist)

cleanup(x, cdata = TRUE)

coerceDDI(element, name = NULL)

collectMetadata(from, ...)

collectRMetadata(from, ...)

extractData(xml)

formatExample(xml_node, level = 0, indent = 2, output = NULL, ...)

generateID(x, nchars = 16)

getDateTime()

getDelimiter(x)

getDNS(xml)

getEnter(OS)

getFiles(path = ".", type = "*", currdir)

getFormat(x, type = c("SPSS", "Stata"), ...)

getHashes(nodes)

getValues(variable)

getXML(path, encoding = "UTF-8")

hasLabels(x)

hasMissingLabels(variables)

makeLabelled(x, variables, declared = TRUE)

missingValuesSPSS(variables, range = FALSE, numvars = TRUE)

prespace(text, indent = NULL)

removeExtra(element)

repeatSpace(times, indent)

replaceChars(x)

replaceTicks(x)

splitrows(x, enter, y = 80, spacerep = "")

treatPath(path, type = "*", single = FALSE, check = TRUE)

writeMetadata(variables, OS = "", indent = 4)

XMLtoRmetadata(xmlvar, dns)

makeNotes(data)

getMetadata(...)

exportDDI(...)

writeRlist(variables, OS = "windows", indent = 4, dirpath = "", filename = "")
}
\arguments{
\item{x}{Number of ID values to return}

\item{nchars}{Number of characters for each ID}
}
\value{
\code{changeXMLang}: A modified \code{codeBook} element.

\code{checkElement}: Boolean.

\code{checkExisting}: Boolean.

\code{checkType}: A character scalar

\code{cleanup}: A character vector

\code{coerceDDI}: A standard element of class DDI

\code{collectMetadata}: a standard DDI Codebook element \code{dataDscr},
containing variable level metadata information

\code{collectRMetadata}: an R list containing variable level metadata information

\code{extractData}: An R data frame, if existing, or NULL

\code{generateID}: Character vector

\code{getDateTime}: Character vector

\code{getDelimiter}: Character scalar

\code{getDNS}: Character scalar

\code{getEnter}: Character scalar

\code{getFiles}: A list with four components: the complete path, the files, the file names and the file extensions

\code{getFormat}: Character scalar

\code{getHashes}: Character vector

\code{getValues}: A list with two components: \code{labels} and \code{na_values}

\code{getXML}: An XML document

\code{hasLabels}: Boolean

\code{hasMissingLabels}: Boolean vector

\code{makeLabelled}: A modified data frame.

\code{missingValuesSPSS}: A vector of missing values representation.

\code{prespace}: A modified text.

\code{removeExtra}: A modified element.

\code{repeatSpace}: Character spaces

\code{replaceChars}: Character vector

\code{replaceTicks}: A recoded string.

\code{splitrows}: A character vector.

\code{treatPath}: A list with four components: the complete path, the
files, the file names and the file extensions

\code{XMLtoRmetadata}: An R list containing metadata
}
\description{
Functions to be used internally, only by developers and
contributors.

\code{ascii}: Convert accented unicode characters to pure ascii

\code{changeXMLang}: Remove the \code{xmlang} attribute from all elements.

\code{checkArgument}: Check function arguments

\code{checkDots}: Check the three dots ... argument.
If the argument is not supplied via dots, returns a default

\code{checkElement}: Check if an element is a DDI Codebook element

\code{checkExisting}: Check if a certain (sub)element exists in a DDI Codebook.

\code{checkType}: Determine the variable type: categorical, numerical or mixed

\code{checkXMList}: Determine if an XML list is a DDI Codebook

\code{cleanup}: Rectify texts read from a metadata object

\code{coerceDDI}: Recursive coerce an element to a DDI class

\code{collectMetadata}: Collect metadata from a file or a dataframe object

\code{collectRMetadata}: Collect metadata from a dataframe object

\code{extractData}: Extract data from an DDI Codebook XML document or
list.

\code{formatExample}: Format an example from the DDI Codebook
specification

\code{generateID}: Generate simple, custom unique ID codes

\code{getDateTime}: Current date and time

\code{getDelimiter}: Guess the column delimiter from a text file

\code{getDNS}: Extracts the Default Name Space from an XML object

\code{getEnter}: Get the carriage return code from the current Operating System

\code{getFiles}: Get information about the files in a given directory

\code{getFormat}: Determine the SPSS / Stata variable format

\code{getHashes}: Compute hashes of XML nodes

\code{getValues}: Extract values, labels and missing values from a \code{var} element

\code{getXML}: Read the DDI XML file, testing if it can be loaded.

\code{hasLabels}: Check if a dataset has (declared) labels

\code{hasMissingLabels}: Check if variables have missing labels

\code{makeLabelled}: Coerce variables to labelled objects

\code{missingValuesSPSS}: Prepares the missing values for the SPSS export syntax.

\code{prespace}: Prepend a text with a certain number of space characters.

\code{removeExtra}: Removes extra information from a DDI Codebook element

\code{repeatSpace}: Allows indentation of XML or HTML files

\code{replaceChars}: Replace certain characters, in preparation for XML export

\code{replaceTicks}: Recode all tick characters with a single quote.

\code{splitrows}: Split the written rows in the setup file.

\code{treatPath}: Determine which specific type of files are
present in a certain directory.

\code{writeMetadata}: Utility function to write the metadata
part in the setup file.

\code{XMLtoRmetadata}: Extract metadata from a single XML variable

\code{writeRlist}: Write an .R file containing a metadata specific list.
}
\keyword{internal}
