% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCodebook.R
\name{getCodebook}
\alias{getCodebook}
\title{Extract metadata information}
\usage{
getCodebook(from = NULL, encoding = "UTF-8", ignore = NULL, ...)
}
\arguments{
\item{from}{A path to a file, or a data frame object}

\item{encoding}{The character encoding used to read a file}

\item{ignore}{Character, ignore DDI elements when reading from an XML file}

\item{...}{Additional arguments for this function (internal use only)}
}
\value{
An R list roughly equivalent to a DDI Codebook, containing all variables,
their corresponding variable labels and value labels, and (if applicable)
missing values if imported and found.
}
\description{
Extract a list containing the variable labels, value labels and any
available information about missing values.
}
\details{
This function extracts the metadata from an R dataset, or alternatively it
can read an XML file containing a DDI codebook version 2.6, or an
SPSS or Stata file and returns a list containing the variable labels, value
labels and information about the missing values.

If the input is a dataset, it will extract the variable level metadata
(labels, missing values etc.). From a DDI XML file, it will import all
metadata elements, the most expensive being the data description.

For the moment, only DDI Codebook is supported, but DDI Lifecycle is planned
to be implemented.
}
\examples{
x <- data.frame(
    A = declared(
        c(1:5, -92),
        labels = c(Good = 1, Bad = 5, NR = -92),
        na_values = -92
    ),
    C = declared(
        c(1, -91, 3:5, -92),
        labels = c(DK = -91, NR = -92),
        na_values = c(-91, -92)
    )
)

getCodebook(from = x)

}
\author{
Adrian Dusa
}
