\name{dde}
\alias{dde}
\docType{data}
\title{
Dichlorodiphenyldichloroethylene (DDE) and preterm delivery data
}
\description{
Data set associated with a study aimed to evaluate the association between maternal serum concentration of the DDT metabolite DDE and preterm delivery. For details, see Longnecker et al. (2001).
}
\usage{data("dde")}
\format{
  A data frame with 2312 observations on the following 2 variables.
  \describe{
    \item{\code{DDE}}{the level of the Dichlorodiphenyldichloroethylene (DDE)}
    \item{\code{GAD}}{the gestational age at delivery (GAD), in days.}
  }
}
\source{
The dataset can be downloaded from \url{https://github.com/tommasorigon/LSBP/blob/master/Tutorial/dde.RData}.
}
\references{
Longnecker, M. P., Klebanoff, M. A., Zhou, H., and Brock, J. W. (2001). Association between maternal serum concentration of the DDT metabolite DDE and preterm and small-for-gestational-age babies at birth. The Lancet, 358(9276):110-114.
}
\examples{
library(DDPstar)
data(dde)
summary(dde)
}
\keyword{datasets}
