% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{initDGEobjDef}
\alias{initDGEobjDef}
\title{Instantiate a class DGEobjDef object.}
\usage{
initDGEobjDef(levels, primaryAssayNames, types, uniqueTypes)
}
\arguments{
\item{levels}{A character string or vector providing names for new levels}

\item{primaryAssayNames}{A character string or vector, must be the same length as levels
This argument supplies the primaryAssayNames for the corresponding levels.}

\item{types}{A named character vector of new types where the
values indicate the basetype for each named type (optional)}

\item{uniqueTypes}{A name or vector of names to add to the uniqueType list (optional)}
}
\value{
A class DGEobjDef object suitable for use with initDGEobj
}
\description{
Instantiate a class DGEobjDef object.
}
\examples{
    # return the default DGEobj definition
    myDGEobjDef <- initDGEobjDef()

    # Optionally add some new types and levels for metabolomics data
     myDGEobjDef <- initDGEobjDef(levels = "metabolomics",
                                  primaryAssayNames = "intensity",
                                  types <- c(normalizedIntensity = "assay"))

    # When a new level is defined, the itemNames and types for the
    # rowData and colData are automatically established.  The
    # types argument is only needed to define downstream workflow objects.

}
