% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{dlm.retro}
\alias{dlm.retro}
\title{Calculate the location and scale parameters for the time-varying coefficients 
given all the observations. West, M. & Harrison, J., 1997. Bayesian Forecasting
and Dynamic Models. Springer New York.}
\usage{
dlm.retro(mt, CSt, RSt, nt, dt)
}
\arguments{
\item{mt}{the vector or matrix of the posterior mean (location parameter), dim = \code{p x T}, 
where \code{p} is the number of thetas (at any time \code{t}) and \code{T} is the number of time points}

\item{CSt}{the posterior scale matrix with dim = \code{p x p x T} (unscaled by the observation variance)}

\item{RSt}{the prior scale matrix with dim = \code{p x p x T} (unscaled by the observation variance)}

\item{nt}{vector of the updated hyperparameters for the precision \code{phi} with length \code{T}}

\item{dt}{vector of the updated hyperparameters for the precision \code{phi} with length \code{T}}
}
\value{
smt = the location parameter of the retrospective distribution with dimension \code{p x T}
sCt = the scale matrix of the retrospective distribution with dimension \code{p x p x T}
}
\description{
Calculate the location and scale parameters for the time-varying coefficients 
given all the observations. West, M. & Harrison, J., 1997. Bayesian Forecasting
and Dynamic Models. Springer New York.
}
