% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{Repglmre2}
\alias{Repglmre2}
\title{Loop through all locations and run GLMM for each}
\usage{
Repglmre2(data, formula, location_var, random_effect_var, family)
}
\arguments{
\item{data}{The dataset to be analyzed.}

\item{formula}{The formula for the regression model.}

\item{location_var}{The variable indicating different locations (e.g., `REGCODE`).}

\item{random_effect_var}{The variable to be used as a random effect (e.g., `hhid`).}

\item{family}{The family to be used for GLM (e.g., `binomial` for logistic regression, `poisson` for Poisson regression).}
}
\value{
A dataframe containing the results
}
\description{
This function runs a mixed-effects generalized linear model (GLMM) for each location within a dataset.
}
\examples{
set.seed(123)

# Create dummy data
  library(dplyr)
dummy_data <- data.frame(
  years_education = rnorm(100, 12, 3),    # Represents years of education
  gender_female = rbinom(100, 1, 0.5),    # 1 = Female, 0 = Male
  household_wealth = sample(1:5, 100, replace = TRUE),  # Wealth index from 1 to 5
  district_code = sample(1:10, 100, replace = TRUE)     # Represents district codes
) \%>\% arrange(district_code)

# Create HHid (Household ID), grouping every 3-4 records, and convert to character
dummy_data$HHid <- as.character(rep(1:20, each = 5, length.out = nrow(dummy_data)))

# Create a binary outcome variable for years of education
dummy_data$education_binary <- ifelse(dummy_data$years_education > 11, 1, 0)

# Define a logistic regression formula
formula <- education_binary ~ gender_female + household_wealth:gender_female

location_var <- "district_code"
random_effect_var <- "HHid"

# Run the logistic mixed-effects model across all locations (districts)
results <- DHSr::Repglmre2(data = dummy_data, formula = formula,
                           location_var = location_var, random_effect_var = random_effect_var,
                           family = binomial())

# Print the results
print(head(results))
}
