test_that("single_lm2 runs linear regression correctly", {
  # Create dummy data
  set.seed(123)
  dummy_data <- data.frame(
    years_education = rnorm(100, 12, 3),
    gender_female = rbinom(100, 1, 0.5),
    household_wealth = sample(1:5, 100, replace = TRUE),
    district_code = sample(1:10, 100, replace = TRUE)
  )

  # Define formula
  formula <- years_education ~ gender_female + household_wealth + household_wealth:gender_female

  # Run the function for district_code 1
  result <- single_lm2(dummy_data, formula, "district_code", response_distribution = "normal", location_index = 1)

  # Test if the result contains the expected columns
  expect_true("estimate" %in% colnames(result))
  expect_true("std_error" %in% colnames(result))

  # Test if the result has the correct number of rows (coefficients + R-squared)
  expect_equal(nrow(result), 5)

  # Check if R-squared is included
  expect_true(any(result$term == "R-squared"))
})
