% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurveySim.R
\name{surveySim}
\alias{surveySim}
\title{Survey Simulations}
\usage{
surveySim(
  survey.parameters,
  artifact.analysis = TRUE,
  plot = TRUE,
  plot.artifacts = FALSE,
  areaprecision = 1000
)
}
\arguments{
\item{survey.parameters}{List of class \code{surveySim}. See package's vignette or the help of \code{parametersExample} for details.
The following items must be included in list of class \code{surveySim}\itemize{
\item \code{col.width} the space between columns in the grid IN METERS
\item \code{grid.type} options are: "square","rectangle","staggered","hexagonal","arbitrary.staggered", following Kintigh 1988
\item \code{simulations} number of random maps to be created and contrasted with the grids
\item \code{area} vector with horizontal and vertical size of area surveyed in km
OBS: Sites will all be ellipses with radii not too different and random angles
\item \code{site.density} measured as number of sites/\ifelse{html}{\out{km<sup>2</sup>}}{\eqn{km^2}}. Can be either one value or a vector with 2 values (min and max) to create a range of densities
\item \code{site.area} can be one of two options: 1. one value indicating the area of all sites, in \ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}};
or 2. a vector with 4 values: min, max, mean (or median), and standard deviation in \ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}}
\item \code{overlap} maximum overlap of site area, ranging from 0 = no overlap allowed to 1 = complete overlap possible
\item \code{obj.density} artifacts per \ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}}. Can be a single value (uniform for all sites) or a range of values defined as min and max
\item \code{obj.distribution} type of cloud distribution for artifacts inside sites. Choose from: 'uniform', 'linear', 'spherical', 'sinusoidal'
\item \code{survey.radius} the radius of the survey pit (assumed to be a circle)
}}

\item{artifact.analysis}{Includes the analysis of artifacts in sites. Can be very time-consuming for mid-high artifact densities. Default = \code{TRUE}}

\item{plot}{If \code{TRUE} the last iteration of the simulations will be plotted.}

\item{plot.artifacts}{If \code{TRUE} the artifacts in each site will be plotted. Default = \code{FALSE} because it is resource intensive for mid-high densities.}

\item{areaprecision}{Area covered by sites is approximated by a cookie-cutter approach. Default precision = \code{1000}
gives approximate area within 1\% error. Higher values reduce error but are more resource intensive.}
}
\value{
A list with four objects: \tabular{ll}{
\code{Summary} \tab A matrix with summary statistics about number of surveys, frequency of site founds, artifacts presence, and success rate of simulations.\cr
\tab \cr
\code{BySite} \tab A matrix with results of the analyses by site from each of the survey areas created in the simulation. \cr
\tab \cr
\code{ByArtifact} \tab A matrix with results of the analyses by artifact presence in survey pits from each of the survey areas created in the simulation. \cr
\tab \cr
\code{Parameters} \tab A list with the parameters used to run the simulation. \cr
}
#'@references
Kintigh (1988) The Effectiveness of Subsurface Testing: A Simulation Approach.
American Antiquity, 53:686-707. \doi{10.2307/281113}
}
\description{
Master function that runs survey simulations
}
\details{
\code{surveySim()} is the main function that will conduct the simulations
of survey grids based on the Survey Parameters created by user.
}
\examples{
\donttest{
#Runs simulations based on parametersExample
surveyExample<-surveySim(parametersExample)

#Edit parametersExample to have 50 simulations and then run simulations
tmp_parameters <-parametersExample
tmp_parameters$simulations<-50
survey50<-surveySim(tmp_parameters)
}
}
