% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAmixtureData.R
\name{DNAmixtureData}
\alias{DNAmixtureData}
\title{Create a data set for a DNA mixture model}
\usage{
DNAmixtureData(data, database, K = character(0), reference.profiles = NULL)
}
\arguments{
\item{data}{Either one \code{data.frame} containing variables
\code{markers} and \code{allele}, \code{height}, or a list of one
or more of such \code{data.frame}s, corresponding to each EPG. If
a \code{data.frame} with reference profiles are not specified
separately, these should be found amongst the datasets.}

\item{database}{A \code{data.frame} with variables \code{marker},
\code{allele}, and allele \code{frequency}.}

\item{K}{Names for reference profiles.}

\item{reference.profiles}{Optionally, a \code{data.frame} containing allele counts for
each reference profile specified in \code{K}. There should be one variable for each name
in \code{K} as well as variables \code{marker} and \code{allele}.}
}
\value{
list of \code{data.frame}'s indexed by markers and
containing variables
\item{\code{marker}}{The STR marker}
\item{\code{allele}}{Repeat number of the allele}
\item{\code{frequency}}{Allele frequency}
\item{\code{height1},\ldots, \code{heightN}}{Peak heights for each of the N mixtures analysed;
their order follows the order in which the mixtures are specified in \code{data}.}
\item{\code{stutter.from}}{For internal use. Where do the alleles get stutter from?
A value of \code{-1} means that the allele cannot receive stutter, corresponding to \code{gets_stutter} being false.
\code{allele[i]} receives stutter from \code{allele[stutter.from[i]]}}
\item{stutter.to}{As above. \code{allele[i]} can stutter to \code{allele[stutter.to[i]]}}
as well as known DNA profiles as labelled by \code{K}.
}
\description{
The function is intended for internal use in
\code{\link{DNAmixture}} and its purpose is to combine peak height
data, any reference profiles, and allele frequencies.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\examples{
## Create a dataset for two markers with each 3 observed alleles
epgdf <- data.frame(marker = rep(c("FGA", "TH01"), each = 3),
                    allele = c(18, 23, 27, 7, 8, 9.3), ## Observed alleles
                    height = c(100, 100, 200, 200, 100, 100), ## Peak heights
                    Anna = c(0,0,2,1,0,1),             ## Anna's profile
                    Peter = c(1,1,0,1,1,0))            ## Peter's profile

data(USCaucasian)
dat <- DNAmixtureData(epgdf, K = c("Anna", "Peter"), database = USCaucasian)
}
\author{
Therese Graversen
}
